﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.BAL
{


    [DataObjectAttribute()]
    public static class QuotationsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Quotations GetItem(Guid QuotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return QuotationsDB.GetItem(QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Quotations> GetList(Guid QuotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return QuotationsDB.GetList(QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid QuotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return QuotationsDB.GetDataTable(QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid QuotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return QuotationsDB.GetDataSet(QuotationsID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Quotations myQuotations)
        {
            if (!GlobalConfigurations.AppConfiguration.IsLocalDatabase) //If local database, first complete the current transaction because SQL CE won't support distributed transaction
            {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                QuotationsDB.Save(myQuotations);

                foreach (QuotationsDetails myQuotationsDetails in myQuotations.QuotationsDetailsList)
                {
                    myQuotationsDetails.Mode = myQuotations.Mode;
                    myQuotationsDetails.QuotationsID = myQuotations.UniqueID;
                    QuotationsDetailsDB.Save(myQuotationsDetails);
                }

                myTransactionScope.Complete();
                return true;
            }
        }
            else
        {
                QuotationsDB.Save(myQuotations);
                foreach (QuotationsDetails myQuotationsDetails in myQuotations.QuotationsDetailsList)
            {
                    myQuotationsDetails.Mode = myQuotations.Mode;
                    myQuotationsDetails.QuotationsID = myQuotations.UniqueID;
                    QuotationsDetailsDB.Save(myQuotationsDetails);
                }
                return true;
            }
        }

        

    }
}
